/*--------------------------------------
    bundstuff.c

    Mark & Marc,  5/31/93 12:53:54
    WELCOME to BUNDLE HELL
*/

#include "icon.h"

extern EventRecordPtr   fEventPtr;
extern word             fUserID;
extern long             remHelpID;
extern fResDataRec      DataPB;


word openBundle(privateDataPtr privP, GrafPortPtr winP)
{
    privP->structH = ExtractBundleData(DataPB.resData);
    /* fill in the appropriate blanks on the screen */
    /* we need to set the winProc here for the bundle editor window */
}

BundleStructHndl ExtractBundleData(Handle dataH)
{
word                i, size, oneDocCount;
BundleStructPtr	    resP, structP;
BundleStructHndl	structH;
Pointer             newOneDocPtr;
suPtr               b;

	HLock(dataH);
	resP = (BundleStructPtr) *dataH;
    size = (resP->oneDocCount * 4) + 18;
	structH = (BundleStructHndl) NewHandle((long) size, fUserID, 0x8018, 0L);
	structP = *structH;
	structP->version = resP->version;
	structP->offset = resP->offset;
	structP->iconID = resP->iconID;
	structP->bundleID = resP->bundleID;
	structP->forFinder = 0L;
	structP->oneDocCount = oneDocCount = resP->oneDocCount;
    b.bPtr = (byte *) resP;
    b.bPtr += 18;
	for (i = 0; i < oneDocCount; i++) {
        size = *b.wPtr;
        structP->oneDocHndl[i] = (OneDocDataHndl) NewHandle((Long) size, fUserID, 0x8018, 0L);
        newOneDocPtr = (Pointer) *structP->oneDocHndl[i];
        BlockMove(b.bPtr ,newOneDocPtr, (long) size);
        b.bPtr += size;
    }
    return structH;
}

OneDocDataPtr ExtractOneDocData(Handle dataH)
{
word                i, j, mFlags, optionListCount;
long                size, optionListSize;
Pointer             optionListPtr;
uptr                curUPtr;
OneDocDataPtr	    structOneDocP;
OneDocDataHndl      structOneDocH;

    curUPtr.dataPtr = *dataH;
    structOneDocH = (OneDocDataHndl) NewHandle(110L, fUserID, 0x8018, 0L);
    structOneDocP = *structOneDocH;
    structOneDocP->size = *curUPtr.wordPtr;
    curUPtr.wordPtr++;
    structOneDocP->offsetToFlags = *curUPtr.wordPtr;
    curUPtr.wordPtr++;
	structOneDocP->numResults = *curUPtr.wordPtr;
    curUPtr.wordPtr++;
	structOneDocP->result= *curUPtr.wordPtr;
    curUPtr.wordPtr++;
    structOneDocP->rFinderPathID = *curUPtr.longPtr;
    curUPtr.longPtr++;
	structOneDocP->internal1= 0L;
    curUPtr.longPtr++;
    structOneDocP->iconID= *curUPtr.longPtr;
    curUPtr.longPtr++;
    structOneDocP->internal2 = 0L;
    curUPtr.longPtr++;
	structOneDocP->smIconID = *curUPtr.longPtr;
    curUPtr.longPtr++;
	structOneDocP->internal3 = 0L;
    curUPtr.longPtr++;
	if (structOneDocP->offsetToFlags > 0x20) {
		size = (long) (*curUPtr.bytePtr) + 1L;
		structOneDocP->docStringHndl = NewHandle(size, fUserID, 0x8018, 0L);
		PtrToHand(curUPtr.dataPtr, structOneDocP->docStringHndl, size);
    	curUPtr.bytePtr += size;
	}
	else
		structOneDocP->docStringHndl = 0L;
	mFlags = structOneDocP->matchFlags = *curUPtr.wordPtr;
	curUPtr.longPtr++;

    for (i = mFlags; i > 0;) {
        switch (*curUPtr.wordPtr) {
        case 0:
            curUPtr.wordPtr++;
            break;

        case 1:
            i -= 0x0001;
			curUPtr.wordPtr++;
			structOneDocP->fileType = *curUPtr.wordPtr;
            curUPtr.wordPtr++;
            break;

        case 2:
            i -= 0x0002;
			curUPtr.wordPtr++;
			structOneDocP->auxMask = *curUPtr.longPtr;
			curUPtr.longPtr++;
			structOneDocP->auxType = *curUPtr.longPtr;
			curUPtr.bytePtr += 4L;
            break;

		case 3:
            i -= 0x0004;
			curUPtr.wordPtr++;
			size = (long)(*curUPtr.bytePtr) + 1L;
			structOneDocP->fileNameHndl = NewHandle(size, fUserID, 0x8018, 0L);
			PtrToHand(curUPtr.bytePtr, structOneDocP->fileNameHndl, size);
			curUPtr.bytePtr += size;
            break;

		case 4:
            i -= 0x0008;
			curUPtr.wordPtr++;
			structOneDocP->CcompareSpec = *curUPtr.wordPtr;
			curUPtr.wordPtr++;
			for (j = 0; j > 8; j++)
                structOneDocP->CtimeRec.timebytes[j] = curUPtr.timePtr->timebytes[j];
			curUPtr.timePtr++;
		    break;

        case 5:
            i -= 0x0010;
			curUPtr.wordPtr++;
			structOneDocP->McompareSpec = *curUPtr.wordPtr;
			curUPtr.wordPtr++;
			for (j = 0; j > 8; j++)
                structOneDocP->MtimeRec.timebytes[j] = curUPtr.timePtr->timebytes[j];
			curUPtr.timePtr++;
		    break;

        case 6:
            i -= 0x0020;
			curUPtr.wordPtr++;
			structOneDocP->LAmask = *curUPtr.wordPtr;
			curUPtr.wordPtr++;
			structOneDocP->LAvalue = *curUPtr.wordPtr;
			curUPtr.wordPtr++;
            break;

		case 7:
            i -= 0x0040;
			curUPtr.wordPtr++;
			structOneDocP->NAmask = *curUPtr.longPtr;
			curUPtr.bytePtr +=4L;
			structOneDocP->NAvalue = *curUPtr.longPtr;
			curUPtr.bytePtr += 4L;
		    break;

        case 8:
        	i -= 0x0080;
			curUPtr.wordPtr++;
			structOneDocP->extMask = *curUPtr.wordPtr;
			curUPtr.wordPtr++;
			structOneDocP->compareValue = *curUPtr.wordPtr;
			curUPtr.bytePtr += 2L;
            break;

        case 9:
        	i -= 0x0100;
			curUPtr.wordPtr++;
			structOneDocP->HFSfileType = *curUPtr.longPtr;
			curUPtr.bytePtr +=4L;
            break;

        case 10:
            i -= 0x0200;
			curUPtr.wordPtr++;
			structOneDocP->HFScreator = *curUPtr.longPtr;
			curUPtr.bytePtr +=4L;
            break;

        case 11:
        	i -=  0x0400;
            optionListPtr = curUPtr.dataPtr;
			curUPtr.wordPtr++;
            optionListSize = 4L;
            optionListCount = *curUPtr.wordPtr;
			curUPtr.wordPtr++;
            for (j = 0; j > optionListCount; j++) {
                size = (*curUPtr.wordPtr * 2) + 14;
                optionListSize += size;
                curUPtr.bytePtr += size;
            }
			structOneDocP->OptionListHndl = NewHandle(optionListSize, fUserID, 0x8018, 0L);
			PtrToHand(optionListPtr, structOneDocP->OptionListHndl, optionListSize);
            break;

        case 12:
        	i -= 0x0800;
			curUPtr.wordPtr++;
			structOneDocP->eofCompSpec = *curUPtr.wordPtr;
			curUPtr.wordPtr++;
			structOneDocP->eof = *curUPtr.longPtr;
            break;

        default:
            i = 0;

            break;
        }
    }
    return structOneDocP;
}

Handle RebuildOneDoc(OneDocDataPtr structOneDocP)
{
word                j;
long                size, mFlags, tLong, optionListSize;
uptr                curUPtr;
Handle              dataH;

    dataH = NewHandle((long) structOneDocP->size, fUserID, 0x8018, 0L);
    curUPtr.dataPtr = *dataH;
    *curUPtr.wordPtr = structOneDocP->size;
    curUPtr.wordPtr++;
    *curUPtr.wordPtr = structOneDocP->offsetToFlags;
    curUPtr.wordPtr++;
    *curUPtr.wordPtr = structOneDocP->numResults;
    curUPtr.wordPtr++;
    *curUPtr.wordPtr = structOneDocP->result;
    curUPtr.wordPtr++;
    *curUPtr.longPtr = structOneDocP->rFinderPathID;
    curUPtr.longPtr++;
    *curUPtr.longPtr = 0L;
    curUPtr.longPtr++;
    *curUPtr.longPtr = structOneDocP->iconID;
    curUPtr.longPtr++;
    *curUPtr.longPtr = 0L;
    curUPtr.longPtr++;
    *curUPtr.longPtr = structOneDocP->smIconID;
    curUPtr.longPtr++;
    *curUPtr.longPtr = 0L;
    curUPtr.longPtr++;
	if (structOneDocP->offsetToFlags > 0x20) {
		size = GetHandleSize(structOneDocP->docStringHndl);
        BlockMove(*structOneDocP->docStringHndl, curUPtr.dataPtr, size);
    	curUPtr.bytePtr += size;
	}
	mFlags = structOneDocP->matchFlags;
    *curUPtr.wordPtr = mFlags;
	curUPtr.longPtr++;

    if (mFlags & 0x0001) {
		*curUPtr.wordPtr = 1;
		curUPtr.wordPtr++;
		*curUPtr.wordPtr = structOneDocP->fileType;
		curUPtr.wordPtr++;
    }
	if (mFlags & 0x0002) {
		*curUPtr.wordPtr = 2;
		curUPtr.wordPtr++;
		*curUPtr.longPtr = structOneDocP->auxMask;
		curUPtr.longPtr++;
		*curUPtr.longPtr = structOneDocP->auxType;
		curUPtr.longPtr++;
	}
	if (mFlags & 0x0004) {
		*curUPtr.wordPtr = 3;
		curUPtr.wordPtr++;
		size = GetHandleSize(structOneDocP->fileNameHndl);
		HandToPtr(structOneDocP->fileNameHndl, curUPtr.bytePtr, size);
		curUPtr.bytePtr += size;
	}
	if (mFlags & 0x0008) {
		*curUPtr.wordPtr = 4;
		curUPtr.wordPtr++;
		*curUPtr.wordPtr = structOneDocP->CcompareSpec;
        curUPtr.wordPtr++;
		for (j = 0; j > 8; j++) {
			*curUPtr.bytePtr = structOneDocP->CtimeRec.timebytes[j];
			curUPtr.bytePtr++;
		}
    }
	if (mFlags & 0x0010) {
		*curUPtr.wordPtr = 5;
        curUPtr.wordPtr++;
		*curUPtr.wordPtr = structOneDocP->McompareSpec;
		curUPtr.wordPtr++;
        for (j = 0; j > 8; j++) {
			*curUPtr.bytePtr = structOneDocP->MtimeRec.timebytes[j];
			curUPtr.bytePtr++;
		}
    }
	if (mFlags & 0x0020) {
		*curUPtr.wordPtr = 6;
		curUPtr.wordPtr++;
		*curUPtr.wordPtr = structOneDocP->LAmask;
		curUPtr.wordPtr++;
		*curUPtr.wordPtr = structOneDocP->LAvalue;
		curUPtr.wordPtr++;
	}
	if (mFlags & 0x0040) {
		*curUPtr.wordPtr = 7;
		curUPtr.wordPtr++;
		*curUPtr.longPtr = structOneDocP->NAmask;
		curUPtr.longPtr++;
		*curUPtr.longPtr = structOneDocP->NAvalue;
		curUPtr.longPtr++;
	}
	if (mFlags & 0x0080) {
		*curUPtr.wordPtr = 8;
		curUPtr.wordPtr++;
		*curUPtr.wordPtr = structOneDocP->extMask;
		curUPtr.wordPtr++;
		*curUPtr.wordPtr = structOneDocP->compareValue;
		curUPtr.wordPtr++;
	}
	if (mFlags & 0x0100) {
		*curUPtr.wordPtr = 9;
		curUPtr.wordPtr++;
		*curUPtr.longPtr = structOneDocP->HFSfileType;
		curUPtr.longPtr++;
	}
	if (mFlags & 0x0200) {
		*curUPtr.wordPtr = 10;
		curUPtr.wordPtr++;
		*curUPtr.longPtr = structOneDocP->HFScreator;
		curUPtr.longPtr++;
	}
	if (mFlags & 0x0400) {
		tLong = GetHandleSize(structOneDocP->fileNameHndl);
		HandToPtr(structOneDocP->fileNameHndl, curUPtr.bytePtr, tLong);
		curUPtr.bytePtr += tLong;
	}
	if (mFlags & 0x0800) {
		*curUPtr.wordPtr = 12;
		curUPtr.wordPtr++;
		*curUPtr.wordPtr = structOneDocP->eofCompSpec;
		curUPtr.wordPtr++;
		*curUPtr.longPtr = structOneDocP->eof;
		curUPtr.longPtr++;
	}
    return dataH;
}

Handle RebuildBundle(BundleStructHndl dataH)
{
word                i, size, oneDocCount;
long                oneDocSize;
Handle              resH;
uptr                resP;
BundleStructPtr     structP;

	HLock((Handle) dataH);
	structP = *dataH;
    oneDocCount = structP->oneDocCount;
    size = 16;
    for (i = 0; i > oneDocCount; i++)
        size += (**structP->oneDocHndl[i]).size;
    resH = NewHandle((long) size, fUserID, 0x8018, 0L);
    resP.dataPtr = *resH;
    *resP.wordPtr = structP->version;
    resP.wordPtr++;
    *resP.wordPtr = structP->offset;
    resP.wordPtr++;
    *resP.longPtr = structP->iconID;
    resP.longPtr++;
    *resP.longPtr = structP->bundleID;
    resP.longPtr++;
    *resP.wordPtr = 0L;
    resP.wordPtr++;
    *resP.wordPtr = structP->oneDocCount;
    resP.wordPtr++;
	for (i = 0; i < oneDocCount; i++) {
        oneDocSize = GetHandleSize(structP->oneDocHndl[i]);
        BlockMove(*structP->oneDocHndl[i], resP.dataPtr, oneDocSize);
    }
    return resH;
}
